declare class Event<T = any> implements IEvent<T> {
    private listeners: Array<(data: T) => void>;
    private onceListeners: Array<(data: T) => void>;
    private enabled: boolean;

    add(listener: (data: T) => void): void;
    addOnce(listener: (data: T) => void): void;
    remove(listener: (data: T) => void): void;
    clear(): void;
    trigger(data: T): void;
    disable(): void;
    enable(): void;
    listenerCount(): number;
}

interface IEvent<T = any> {
    add(listener: (data: T) => void): void;
    addOnce(listener: (data: T) => void): void;
    remove(listener: (data: T) => void): void;
    clear(): void;
    trigger(data: T): void;
    disable(): void;
    enable(): void;
    listenerCount(): number;
}

interface Tooltip extends ScriptComponent {

}

interface SideSwitcher extends ScriptComponent {
    switchToNext(): void
    switchTo(icon: number): void
    show(): void
    hide(): void
    disableIconBackground(): void
    enableIconBackground(): void
    enableInteractable(): void
    disableInteractable(): void
    tooltip?: Tooltip
    visible: boolean
    activeIconIndex: number
    eventTag: string
    iconOpacity: number
    backgroundOpacity: number
    icons: Texture[]

    onSwitch: Event<number>
    onShow: Event<number>
    onHide: Event<number>
}

interface Tooltip extends BaseScriptComponent {
    autostart: boolean,
    label: string,
    show(): void,
    hide(): void,
    direction: "Left"|"Right"|"Top"|"Bottom",
}
